@extends('backend.master')

@section('title')
    {{ @$data['title'] }}
@endsection
@section('content')
    <div class="page-content">
        {{-- bradecrumb Area S t a r t --}}
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h4 class="bradecrumb-title mb-1">{{ $data['title'] }}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ ___('common.home') }}</a></li>
                            <li class="breadcrumb-item" aria-current="page"><a
                                    href="{{ route('tenants.index') }}">{{ ___('common.tenants') }}</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">{{ ___('common.add_new') }}</li>
                        </ol>
                </div>
            </div>
        </div>
        {{-- bradecrumb Area E n d --}}
        <div class="card ot-card">
            <div class="card-body">
                <form action="{{ route('tenants.store') }}" enctype="multipart/form-data" method="post"
                id="visitForm">
                    @csrf
                    <div class="row mb-3">
                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ ___('common.name') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('name') is-invalid @enderror" name="name"
                                        list="datalistOptions" id="exampleDataList"
                                        placeholder="{{ ___('common.enter_name') }}">
                                    @error('name')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ ___('common.email') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('email') is-invalid @enderror"
                                        name="email" list="datalistOptions" id="exampleDataList"
                                        placeholder="{{ ___('common.enter_email') }}">
                                    @error('email')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror


                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ ___('common.phone') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('phone') is-invalid @enderror"
                                        name="phone" list="datalistOptions" id="exampleDataList"
                                        placeholder="{{ ___('common.enter_phone') }}">
                                    @error('phone')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ ___('common.permanent_address') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('permanent_address') is-invalid @enderror"
                                        name="permanent_address" list="datalistOptions" id="exampleDataList"
                                        placeholder="{{ ___('common.enter_permanent_address') }}">
                                    @error('permanent_address')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ ___('common.city') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('city') is-invalid @enderror"
                                        name="city" list="datalistOptions" id="exampleDataList"
                                        placeholder="{{ ___('common.enter_city') }}">
                                    @error('city')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ ___('common.state') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('state') is-invalid @enderror"
                                        name="state" list="datalistOptions" id="exampleDataList"
                                        placeholder="{{ ___('common.enter_state') }}">
                                    @error('state')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ ___('common.zip_code') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('zip_code') is-invalid @enderror"
                                        name="zip_code" list="datalistOptions" id="exampleDataList"
                                        placeholder="{{ ___('common.enter_zip_code') }}">
                                    @error('zip_code')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ ___('common.occupation') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('occupation') is-invalid @enderror"
                                        name="occupation" list="datalistOptions" id="exampleDataList"
                                        placeholder="{{ ___('common.enter_occupation') }}">
                                    @error('occupation')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ ___('common.designation') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('designation') is-invalid @enderror"
                                        name="designation" list="datalistOptions" id="exampleDataList"
                                        placeholder="{{ ___('common.enter_designation') }}">
                                    @error('designation')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ ___('common.nid') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('nid') is-invalid @enderror"
                                        name="nid" list="datalistOptions" id="exampleDataList"
                                        placeholder="{{ ___('common.enter_nid') }}">
                                    @error('nid')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="exampleDataList" class="form-label ">{{ ___('common.passport') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('passport') is-invalid @enderror"
                                        name="passport" list="datalistOptions" id="exampleDataList"
                                        placeholder="{{ ___('common.enter_passport') }}">
                                    @error('passport')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    {{-- File Uplode --}}
                                    <label class="form-label" for="inputImage">{{ ___('common.image') }}</label>
                                    <div class="ot_fileUploader left-side mb-3">
                                        <input class="form-control" type="text" placeholder="{{ ___('common.image') }}"
                                            readonly="" id="placeholder">
                                        <button class="primary-btn-small-input" type="button">
                                            <label class="btn btn-lg ot-btn-primary"
                                                for="fileBrouse">{{ ___('common.browse') }}</label>
                                            <input type="file" class="d-none form-control" name="image" id="fileBrouse"
                                                accept="image/*">
                                        </button>
                                    </div>
                                </div>
                                <div class="col-md-12 mb-3">

                                    {{-- Status --}}
                                    <label for="validationServer04" class="form-label">{{ ___('common.status') }} <span
                                            class="fillable">*</span></label>

                                    <select
                                        class="nice-select niceSelect bordered_style wide @error('status') is-invalid @enderror"
                                        name="status" id="validationServer04"
                                        aria-describedby="validationServer04Feedback">

                                        <option value="{{ App\Enums\Status::ACTIVE }}">{{ ___('common.active') }}</option>
                                        <option value="{{ App\Enums\Status::INACTIVE }}">{{ ___('common.inactive') }}
                                        </option>
                                    </select>
                                    @error('status')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror

                                </div>
                        <div class="col-md-12 mt-24">
                            <div class="text-end">
                                <button class="btn btn-lg ot-btn-primary"><span><i class="fa-solid fa-save"></i>
                                    </span>{{ ___('common.submit') }}</button>
                            </div>
                        </div>
                    </div>
            </div>
        </div>
    </div>
@endsection
