@extends('frontend.layouts.master')

@section('title', @$data['title'])
@section('content')
<!-- home_banner::start  -->
<div class="home_banner bannerUi_active owl-carousel">
    @foreach ($data['sliders'] as $slider)
    <div class="banner_single home_Banner_bg_1" style="background-image:url( {{ @$slider['imageURL'] }}) !important;">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 offset-xl-1">
                    <div class="banner__text">
                        <span>{{ @$slider['highlight_title_one'] }}</span>
                        <h3>{{ @$slider['title'] }}</h3>
                        <a href="{{ @$slider['btn_one'] }}" class="o_land_primary_btn min_200">{{ _trans('landlord.Buy Now')}}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endforeach
</div>
<!-- home_banner::end  -->

<div class="o_land_section section_spacing ">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="section__title d-flex align-items-center gap-3 mb_30 flex-wrap">
                    <h3 class="m-0 flex-fill">{{ _trans('landlord.Trending Property') }}</h3>
                    <a href="{{ route('properties') }}" class="title_link d-flex align-items-center lh-1">
                        <span class="title_text">{{ _trans('landlord.More Deals')}}</span>
                        <span class="title_icon">
                            <i class="fas fa-chevron-right"></i>
                        </span>
                    </a>
                </div>
            </div>
        </div>
        <!-- call getTrendingProperties() for loading the properties -->
        <div class="row custom_rowProduct " id="loading_trending_properties">
        </div>
        {{-- Buy Property --}}
        <div class="row">
            <div class="col-12">
                <div class="section__title d-flex align-items-center gap-3 mb_30 flex-wrap">
                    <h3 class="m-0 flex-fill">{{ _trans('landlord.Buy Property') }}</h3>
                    <a href="{{ route('properties') }}" class="title_link d-flex align-items-center lh-1">
                        <span class="title_text">{{ _trans('landlord.More Deals')}}</span>
                        <span class="title_icon">
                            <i class="fas fa-chevron-right"></i>
                        </span>
                    </a>
                </div>
            </div>
        </div>
        <div class="row custom_rowProduct " id="loading_buying_properties">
        </div>

        {{-- Rent Property --}}
        <div class="row">
            <div class="col-12">
                <div class="section__title d-flex align-items-center gap-3 mb_30 flex-wrap">
                    <h3 class="m-0 flex-fill">{{ _trans('landlord.Rent Property') }}</h3>
                    <a href="{{ route('properties') }}" class="title_link d-flex align-items-center lh-1">
                        <span class="title_text">{{ _trans('landlord.More Deals')}}</span>
                        <span class="title_icon">
                            <i class="fas fa-chevron-right"></i>
                        </span>
                    </a>
                </div>
            </div>
        </div>
        <div class="row custom_rowProduct " id="loading_rent_properties">
        </div>

    </div>
</div>

<!-- o_land_section::start  -->
<div class="o_land_section ">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="section__title d-flex align-items-center gap-3 mb_30 flex-wrap ">
                    <h3 class="m-0 flex-fill">{{ _trans('landlord.Hot Categories')}}</h3>
                    <a href="{{ route('properties') }}" class="title_link d-flex align-items-center lh-1">
                    </a>
                </div>
            </div>
        </div>
        <!-- call loadingHotCategories() for loading the categories -->
        <div class="row" id="__loadingHotCategories">
        </div>
    </div>
</div>
<!-- o_land_section::end  -->
<!-- new  -->

<!-- cta::start  -->
<div class="o_land_section">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="o_land_cta_box">
                    <div class="row justify-content-end ">
                        <div class="col-xl-12 d-flex align-items-center gap-2 flex-wrap ">
                            <div class="o_land_cta_text flex-fill">
                                <span>{{ _trans('landlord.Download App')}}</span>
                                <h4>{{ _trans('landlord.Property buy and sell software')}}</h4>
                                <h5>{{ _trans('landlord.saving time and reducing errors')}}</h5>
                            </div>
                            <a href="#" class="o_land_white_btn min_170 lh-1">{{ _trans('landlord.Explore Now')}}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- cta::end  -->


<div class="o_land_section section_spacing3">
    <div class="container">
        <div class="row">
            <div class="col-12 mb_30">
                <ul class="nav amzcart_tabs d-flex align-items-center justify-content-center flex-wrap " id="myTab"
                    role="tablist">
                    <li class="nav-item " role="presentation">
                        <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home"
                            type="button" role="tab" aria-controls="home" aria-selected="true">{{ _trans('landlord.Top Rating')}}</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile"
                            type="button" role="tab" aria-controls="profile" aria-selected="false">{{ _trans('landlord.People’s choice')}}</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact"
                            type="button" role="tab" aria-controls="contact" aria-selected="false">{{ _trans('landlord.Featured')}}</button>
                    </li>
                </ul>

            </div>
            <div class="col-xl-12">
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                        <!-- conttent  -->
                        <div class="o_land_fieature_active fieature_crousel_area owl-carousel">

                            @foreach ($data['topRatingProperties'] as $item)
                                <!-- SINGLE_WIDGET -->
                                <div class="product_widget5 mb_30">
                                    <div class="product_thumb_upper">
                                        <a href="{{ @$item['details_url'] }}" class="thumb">
                                            <img src="{{ @$item['image'] }}" alt="">
                                        </a>
                                        <div class="product_action">
                                            <a href="compare.php">
                                                <i class="ti-control-shuffle"></i>
                                            </a>
                                            <a data-bs-toggle="modal" data-bs-target="#theme_modal">
                                                <i class="ti-eye"></i>
                                            </a>
                                            <a href="#">
                                                <i class="ti-star"></i>
                                            </a>
                                        </div>
                                        <span class="badge_1 text-uppercase {{ @$item['deal_type'] === 'Rent' ? 'bg_green' : '' }}"> {{ @$item['deal_type'] }} </span>
                                    </div>
                                    <div class="product__meta text-start">
                                        <div class="d-flex justify-content-between flex-wrap gap-2">
                                            <span class="product_banding secondary_text">{{ @$item['category'] }}</span>
                                            <h5 class="f_w_600 font_16"> {{ @$item['rent_amount'] }}</h5>
                                        </div>
                                        <a href="{{ @$item['details_url'] }}">
                                            <h4>{{ @$item['name'] }}</h4>
                                        </a>
                                        <div class="d-flex flex-wrap gap-3  mt_10">
                                            <span
                                                class="body_text d-flex gap_6 align-items-center justify-content-center font_14"><i
                                                    class="fas fa-bed fw-bolder body_text"></i>{{ @$item['bedrooms'] }}</span>
                                            <span
                                                class="body_text d-flex gap_6 align-items-center justify-content-center font_14"><i
                                                    class="far fa-bath fw-bolder body_text"></i>{{ @$item['bathrooms'] }}</span>
                                            <span
                                                class="body_text d-flex gap_6 align-items-center justify-content-center font_14"><i
                                                    class="far fa-border-all fw-bolder body_text"></i>{{ @$item['size'] }} sqft</span>
                                        </div>
                                        <div class="d-flex gap-2 mt-3">
                                            @include('frontend.property.partials.call-email')
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <!-- conttent  -->
                    </div>
                    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                        <!-- conttent  -->
                        <div class="o_land_fieature_active fieature_crousel_area owl-carousel">
                            <!-- SINGLE_WIDGET -->
                            @foreach ($data['topRatingProperties'] as $item)
                                <!-- SINGLE_WIDGET -->
                                <div class="product_widget5 mb_30">
                                    <div class="product_thumb_upper">
                                         <a href="{{ @$item['details_url'] }}" class="thumb">
                                            <img src="{{ @$item['image'] }}" alt="">
                                        </a>
                                        <div class="product_action">
                                            <a href="compare.php">
                                                <i class="ti-control-shuffle"></i>
                                            </a>
                                            <a data-bs-toggle="modal" data-bs-target="#theme_modal">
                                                <i class="ti-eye"></i>
                                            </a>
                                            <a href="#">
                                                <i class="ti-star"></i>
                                            </a>
                                        </div>
                                        <span class="badge_1 text-uppercase {{ @$item['deal_type'] === 'Rent' ? 'bg_green' : '' }}"> {{ @$item['deal_type'] }} </span>
                                    </div>
                                    <div class="product__meta text-start">
                                        <div class="d-flex justify-content-between flex-wrap gap-2">
                                            <span class="product_banding secondary_text">{{ @$item['category'] }}</span>
                                            <h5 class="f_w_600 font_16"> {{ @$item['rent_amount'] }}</h5>
                                        </div>
                                        <a href="{{ @$item['details_url'] }}">
                                            <h4>{{ @$item['name'] }}</h4>
                                        </a>
                                        <div class="d-flex flex-wrap gap-3  mt_10">
                                            <span
                                                class="body_text d-flex gap_6 align-items-center justify-content-center font_14"><i
                                                    class="fas fa-bed fw-bolder body_text"></i>{{ @$item['bedrooms'] }}</span>
                                            <span
                                                class="body_text d-flex gap_6 align-items-center justify-content-center font_14"><i
                                                    class="far fa-bath fw-bolder body_text"></i>{{ @$item['bathrooms'] }}</span>
                                            <span
                                                class="body_text d-flex gap_6 align-items-center justify-content-center font_14"><i
                                                    class="far fa-border-all fw-bolder body_text"></i>{{ @$item['size'] }} {{ _trans('landlord.sqft')}}</span>
                                        </div>
                                        <div class="d-flex gap-2 mt-3">
                                            @include('frontend.property.partials.call-email')
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <!-- conttent  -->
                    </div>
                    <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                        <!-- conttent  -->
                        <div class="o_land_fieature_active fieature_crousel_area owl-carousel">
                            <!-- SINGLE_WIDGET -->
                            @foreach ($data['featuredProperties'] as $item)
                                <!-- SINGLE_WIDGET -->
                                <div class="product_widget5 mb_30">
                                    <div class="product_thumb_upper">
                                        <a href="{{ @$item['details_url'] }}" class="thumb">
                                            <img src="{{ @$item['image'] }}" alt="">
                                        </a>
                                        <div class="product_action">
                                            <a href="compare.php">
                                                <i class="ti-control-shuffle"></i>
                                            </a>
                                            <a data-bs-toggle="modal" data-bs-target="#theme_modal">
                                                <i class="ti-eye"></i>
                                            </a>
                                            <a href="#">
                                                <i class="ti-star"></i>
                                            </a>
                                        </div>
                                        <span class="badge_1 text-uppercase {{ @$item['deal_type'] === 'Rent' ? 'bg_green' : '' }}"> {{ @$item['deal_type'] }} </span>
                                    </div>
                                    <div class="product__meta text-start">
                                        <div class="d-flex justify-content-between flex-wrap gap-2">
                                            <span class="product_banding secondary_text">{{ @$item['category'] }}</span>
                                            <h5 class="f_w_600 font_16"> {{ @$item['rent_amount'] }}</h5>
                                        </div>
                                        <a href="{{ @$item['details_url'] }}">
                                            <h4>{{ @$item['name'] }}</h4>
                                        </a>
                                        <div class="d-flex flex-wrap gap-3  mt_10">
                                            <span
                                                class="body_text d-flex gap_6 align-items-center justify-content-center font_14"><i
                                                    class="fas fa-bed fw-bolder body_text"></i>{{ @$item['bedrooms'] }}</span>
                                            <span
                                                class="body_text d-flex gap_6 align-items-center justify-content-center font_14"><i
                                                    class="far fa-bath fw-bolder body_text"></i>{{ @$item['bathrooms'] }}</span>
                                            <span
                                                class="body_text d-flex gap_6 align-items-center justify-content-center font_14"><i
                                                    class="far fa-border-all fw-bolder body_text"></i>{{ @$item['size'] }} {{ _trans('landlord.sqft')}}</span>
                                        </div>
                                        <div class="d-flex gap-2 mt-3">
                                            @include('frontend.property.partials.call-email')
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <!-- conttent  -->
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<div class="o_land_section o_land_deal_area ">
    <div class="container">
        <div class="row">
            <div class="col-xl-4 col-md-6 col-lg-4">
                <div class="deal_wizard deal_wizard_bg1 mb_30">
                    <h3>{{ _trans('landlord.SCREEN SHIELDS -50%')}}</h3>
                    <a href="{{ route('properties') }}" class="shop_text">{{ _trans('landlord.Shop now')}}</a>
                </div>
            </div>
            <div class="col-xl-4 col-md-6 col-lg-4">
                <div class="deal_wizard deal_wizard_bg2 mb_30">
                    <h3>{{ _trans('landlord.NEW COLOR CASES')}}</h3>
                    <a href="{{ route('properties') }}" class="shop_text">{{ _trans('landlord.Shop now')}}</a>
                </div>
            </div>
            <div class="col-xl-4 col-md-6 col-lg-4">
                <div class="deal_wizard deal_wizard_bg3 mb_30">
                    <h3>{{ _trans('landlord.Daltex Product Example')}}</h3>
                    <a href="{{ route('properties') }}" class="shop_text">{{ _trans('landlord.Shop now')}}</a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- o_land_recomanded::start  -->
<div class="o_land_recomanded_area">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="o_land_recomanded_box mb_60">
                    <div class="o_land_recomanded_box_head px-0 border-0">
                        <h4 class="mb-0">{{ _trans('landlord.Recommendation For You')}}</h4>
                    </div>
                    {{-- <div class="bannerUi_Recommendation_active owl-carousel " id="__recommendation_for_you"> --}}
                    <div class="row " id="__recommendation_for_you">

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- o_land_recomanded::end -->
<!-- o_landingFeatures::start  -->
<div class="o_land_section section_spacing d-none ">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="section__title d-flex align-items-center gap-3 mb_40 flex-wrap">
                    <h3 class="mb_30 flex-fill ">{{ _trans('landlord.Amazing Features')}}</h3>
                </div>
            </div>
        </div>
        <div class="row ">
            <div class="col-xl-12">
                <div class="feature_grid">
                    <div class="Feature_widget">
                        <div class="Feature_widget_content d-flex gap-4 align-items-center flex-wrap">
                            <div class="Feature_widget_content_icon">
                                <img class="img-fluid" src="{{ url('frontend/img/svg/feature1.svg') }}" alt="">
                            </div>
                            <h3 class="Feature_widget_content_title m-0">{{ _trans('landlord.Lead Management')}}</h3>
                        </div>
                        <p class="Feature_widget_desc">{{ _trans('landlord.Organize and track leads, communications and deals.')}}</p>
                    </div>
                    <div class="Feature_widget">
                        <div class="Feature_widget_content d-flex gap-4 align-items-center flex-wrap">
                            <div class="Feature_widget_content_icon">
                                <img class="img-fluid" src="{{ url('frontend/img/svg/feature2.svg') }}" alt="">
                            </div>
                            <h3 class="Feature_widget_content_title m-0">{{ _trans('landlord.Monthly Sales')}}</h3>
                        </div>
                        <p class="Feature_widget_desc">{{ _trans('landlord.Organize and track leads, communications and deals.')}}</p>
                    </div>
                    <div class="Feature_widget">
                        <div class="Feature_widget_content d-flex gap-4 align-items-center flex-wrap">
                            <div class="Feature_widget_content_icon">
                                <img class="img-fluid" src="{{ url('frontend/img/svg/feature3.svg') }}" alt="">
                            </div>
                            <h3 class="Feature_widget_content_title m-0">{{ _trans('landlord.Sales Progress')}}</h3>
                        </div>
                        <p class="Feature_widget_desc">{{ _trans('landlord.Organize and track leads, communications and deals.')}}</p>
                    </div>
                    <div class="Feature_widget">
                        <div class="Feature_widget_content d-flex gap-4 align-items-center flex-wrap">
                            <div class="Feature_widget_content_icon">
                                <img class="img-fluid" src="{{ url('frontend/img/svg/feature4.svg') }}" alt="">
                            </div>
                            <h3 class="Feature_widget_content_title m-0">{{ _trans('landlord.Marketing Automation')}}</h3>
                        </div>
                        <p class="Feature_widget_desc">{{ _trans('landlord.Organize and track leads, communications and deals.')}}</p>
                    </div>
                    <div class="Feature_widget">
                        <div class="Feature_widget_content d-flex gap-4 align-items-center flex-wrap">
                            <div class="Feature_widget_content_icon">
                                <img class="img-fluid" src="{{ url('frontend/img/svg/feature5.svg') }}" alt="">
                            </div>
                            <h3 class="Feature_widget_content_title m-0">{{ _trans('landlord.Reporting & Analytics')}}</h3>
                        </div>
                        <p class="Feature_widget_desc">{{ _trans('landlord.Organize and track leads, communications and deals.')}}</p>
                    </div>
                    <div class="Feature_widget">
                        <div class="Feature_widget_content d-flex gap-4 align-items-center flex-wrap">
                            <div class="Feature_widget_content_icon">
                                <img class="img-fluid" src="{{ url('frontend/img/svg/feature6.svg') }}" alt="">
                            </div>
                            <h3 class="Feature_widget_content_title m-0">{{ _trans('landlord.MLS Integrations')}}</h3>
                        </div>
                        <p class="Feature_widget_desc"></p>{{ _trans('landlord.Organize and track leads, communications and deals.')}}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- o_landingFeatures::end  -->

<div class="o_land_section section_spacing ">
    <div class="container">
        <div class="row">
            <div class="col-12 ">
                <div class="section__title d-flex align-items-center gap-3 mb_40 flex-wrap">
                    <h3 class="m-0 flex-fill ">{{ _trans('landlord.How it works?')}}</h3>
                </div>
            </div>
        </div>
        <div class="row ">
            @foreach ( $data['how_it_works'] as $how_it_work)
            <div class="col-xl-3 col-lg-3 col-md-6">
                <div class="workx_widget text-center mb_30">
                    <div class="icon d-flex align-items-center justify-content-center">
                        <img src="{{ url('frontend/img/svg/property1.svg') }}" alt="" >
                    </div>
                    <div class="context_info text-justify ">
                        <h4>{{ $how_it_work->title }}</h4>
                        <p class="text-justify">{{ $how_it_work->message }}</p>
                    </div>
                </div>
            </div>

            @endforeach
        </div>
    </div>
</div>
<!-- o_land_brand::start  -->
<div class="o_land_brand section_spacing5 pt-0 ">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="section__title d-flex align-items-center gap-3 mb_30">
                    <h3 class="m-0 flex-fill">{{ _trans('landlord.Our Partners')}}</h3>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="o_landBrand_boxes">
                    @foreach($data['partners'] as $partner)
                    <a class="single_brand d-block">
                        <img src="{{ url(@$partner->image->path) }}" alt="{{ $partner->name }}" onclick="showImagePopup(this.src)">
                    </a>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

<!-- o_land_brand::end  -->
@endsection

